;;; -*- Mode: Common-Lisp; Package: dox; Base: 10.; Patch-File: T -*-

;;; Reason: Fixed patch 6.2 to work on microExplorer.

;;;                           RESTRICTED RIGHTS LEGEND
;;;
;;; Use, duplication, or disclosure by the Government is subject to
;;; restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;; Technical Data and Computer Software clause at 252.227-7013.
;;;
;;;   TEXAS INSTRUMENTS INCORPORATED      
;;;   P.O. BOX 149149, M/S 2151             
;;;   AUSTIN, TEXAS 78714-9149                 
;;;
;;; Copyright (C) 1990 Texas Instruments Incorporated.
;;; All rights reserved.

;;; Written 08/27/90 13:58:41 by BERGER,
;;; while running on ARIES from band LODX
;;; With SYSTEM 6.42, VIRTUAL-MEMORY 6.3, EH 6.8, MAKE-SYSTEM 6.5, MICRONET 6.0, LOCAL-FILE 6.2,
;;;  BASIC-PATHNAME 6.5, NETWORK-SUPPORT-COLD 6.2, BASIC-NAMESPACE 6.8, NETWORK-NAMESPACE 6.1,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-FILE 6.15, MAC-PATHNAME 6.0, NETWORK-PATHNAME 6.2,
;;;  COMPILER 6.18, TV 6.32, DATALINK 6.0, CHAOSNET 6.9, GC 6.8, MEMORY-AUX 6.0, NVRAM 6.4,
;;;  SYSLOG 6.2, STREAMER-TAPE 6.8, UCL 6.1, INPUT-EDITOR 6.1, METER 6.2, ZWEI 6.28,
;;;  DEBUG-TOOLS 6.5, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3, DATALINK-DISPLAYS 6.0,
;;;  FONT-EDITOR 6.1, SERIAL 6.0, PRINTER 6.9, MAC-PRINTER-TYPES 6.2, PRINTER-TYPES 6.2,
;;;  IMAGEN 6.1, SUGGESTIONS 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9, TELNET 6.1, VT100 6.0,
;;;  NAMESPACE-EDITOR 6.7, PROFILE 6.3, VISIDOC 6.7, TI-CLOS 6.54, CLEH 6.5, IP 3.67,
;;;  Experimental BUG 11.19, Experimental CLX 7.5, Experimental CLUE 7.24, X11M 6.36,
;;;  Experimental CLIO 1.0, VISIDOC-SERVER 6.2,  microcode 488, Band Name: Release 6.1 + SLE 8/10

#!C
; From file NAMESPACE-SERVER.LISP#> VISIDOC.SERVER; SYS:
#10R DOX#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOX"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: VISIDOC.SERVER; NAMESPACE-SERVER.#"


(defun convert-server-6.0-to-6.1 ()
  "This utility will create a REL 6.1 Visidoc Server file using the Rel 6.0 file. Two attributes in the
    NAMESPACE class, VISIDOC-SERVER object need to be updated to reflect the new version. The manual files
    have not changed, thus requiring no updates to the manual directory or the remaining class object in
    the server file."
  (let (namespace source dest)
    (setf source (send (make-pathname :host "lm" :directory "name-service"
				      :name "visidoc-server-rel-6-0" :type "xld")
		       :merge-device))
    (setf dest (send (make-pathname :host "lm" :directory "name-service"
				      :name "visidoc-server-rel-6-1" :type "xld")
		     :merge-device))
    
    (COND ((probe-file dest)
	   (format t "~%The visidoc server file ~a has already been converted." dest))
	  ((not (probe-file source))
	   (format t "~%~a does not exist. Conversion failed." source))
	  (T					;now do the real work.
	   (format t "~%Beginning conversion.~%Copying 6.0 XLD to 6.1 XLD.")
	   (fs:copy-file source dest)
	   (format t "~%Loading unmodified 6.1 XLD.")
	   (setf namespace (name:load-personal-namespace
			     "visidoc-server-rel-6-1" 
			     :pathname dest))
	   (format t "~%Updating attributes.")
	   (name:add-attribute "visidoc-server" :NAMESPACE :NAMESPACE-FILE-PATHNAME
			       dest
			       :namespace namespace)
	   (name:add-attribute "visidoc-server" :NAMESPACE :VERSION
			       :REL-6-1
			       :namespace namespace)
	   (Format t "~%Saving changes to XLD file.")
	   (SEND namespace :DUMP dest)
	   (format t "~%Cleaning up.")
	   (name:delete-namespace "visidoc-server-rel-6-1")
	   (format t "~%The visidoc server file ~a has been created." dest))))
  )
))
